\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 28))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Atât a iubit Dumnezeu lumea"
  subtitle = "(Ioan 3,16)"
  subsubtitle = "Părintelui Chiril"
  composer = \markup \center-column { "Patima și Învierea Domnului"
    \small "Erlangen, 2023" }
  %meter = "Maestoso"
  tagline=""
}

global = {
  \key f \major
  \time 3/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- tât a iu -- bit Dum -- ne -- zeu lu -- mea.
  A -- tât a iu -- bit Dum -- ne -- zeu __ lu -- mea,
  în -- cât pe sin -- gu -- rul Lui Fiu L-a dat, L-a __ dat,
  pen -- tru ca cel ce cre -- de în El să nu pia -- ră,
  ci să ai -- bă via -- ță,
  ci să ai -- bă via -- ță,
  via -- ță veș -- ni -- că.  
}

menWords = \lyricmode {
  A -- tât a iu -- bit Dum -- ne -- zeu __ lu -- mea.
  A -- tât a iu -- bit Dum -- ne -- zeu __ lu -- mea,
  în -- cât pe sin -- gu -- rul Lui Fiu L-a dat,
  pen -- tru ca cel ce cre -- de în El să nu pia -- ră,
  ci să ai -- bă via -- ță,
  ci să ai -- bă via -- ță,
  via -- ță veș -- ni -- că.
}

sopMusic = \relative c' {
  \partial 4 e4
  f^\p g f e d c d2. c4 c  
  a'4^\mf
  c2 b8 a d2 c8 b c4^\<( d e\!) f^\f f, %r
  %r2. r2 c'4^\markup "a- tât" e 
  %d^\markup "a" c^\markup "iu -" f2^\markup "bit"
  e d2 a'4 b2 b4 g2 e4 a2 d,4 f2.
  b,4( f' e) d2.
  e4^\mf f g a2 a4 d2. c2 c4 d c b c c2
  %f4( g) b a g2
  b2 a4 g2 f4 d'2. c
  g2^\f a4 b( d) c b2. a
  g4^\p( a) b c2^\> c4 c2\!^\fermata
  \bar "|."
}

altoMusic = \relative c' {
  e4 f d b c d c b2. c4 c
  f4
  a2 g8 f b2 a8 b c4( b g) f f 
  %a4 c2.( c2. c2)
  e^\p d2 f4 g2 g4 g2 e4 f2 d4 d2.
  b2( c4) d2.
  e4 f e f2 f4 g2. a2 a4 a a b a a2
  b2 a4 g2 f4 f2. f e2 f4 g( b) a g2. f
  e4( f) g a2 a4 a2
}

bassMusic = \relative c {
  e4 f d b c b c b2( c4) f4 f
  f4 f2 f8 f8 f2 f8 g a4( g c,) f f
  e4 d2 d4 d2 d4 d2 d4 d2 d4 a2. r1*3/4 r
  e'4 d c c2 c4 b2. f'2 f4 f f f f f2
  f2 f4 c2 c4 c2. c c2 c4 g'2 f4 f2. f
  c2 c4 f2 f4 f2
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altoMusic }
      %\addlyrics { \womenWords }
    >>

    \new Staff = "men" <<
      \clef bass
      %\new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \global \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 70
  \context { \Voice \remove "Dynamic_performer" }

}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altoMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}